; ===========================================================================
; ---------------------------------------------------------------------------
; Generic Z80 driver to playback small buffer supplied by 68k - MarkeyJester
; ---------------------------------------------------------------------------

Start:
		di						;  4	; disable interrupts
		im	1					;  8	; set interrupt mode
		ld	sp,02000h				; 10	; setup stack address
		jp	Init					; 10	; jump into loop start

; ===========================================================================
; ---------------------------------------------------------------------------
; V-blank
; ---------------------------------------------------------------------------
		align	038h
; ---------------------------------------------------------------------------

		ld	c,160					;  7	; 170 samples to play
		ld	de,BufferA				; 10	; use buffer A
Buffer:		ld	a,001h					;  7	; load buffer flag
		zneg						;  4	; change buffer
		ld	(Buffer+1),a				; 13	; update buffer flag
		jr	z,.Play					;  7|12	; if we're writing to buffer A, jump to use buffer A
		ld	de,BufferB				; 10	; use buffer B instead
		jp	.Play					; 10	; ''

	.Next:
		ld	b,01Ch					;  7	; delay timer

	.Delay:
		djnz	.Delay					;  8|13	; delay to control sample rate

	.Play:
		ld	a,(de)					;  7	; load sample
		ld	(hl),a					;  7	; dump to YM2612
		inc	e					;  4	; advance to next sample
		dec	c					;  4	; decrease sample counter
		jr	nz,.Next				;  7|13	; repeat for all 160 samples

		retn						; 14	; return to loop

; ===========================================================================
; ---------------------------------------------------------------------------
; Initialisation and loop
; ---------------------------------------------------------------------------

Init:
		ld	hl,04000h				; 10	; YM2612 port

		ld	(hl),02Bh				; 10	; set to DAC switch
		inc	l					;  4	; data port
		znop						;  4	; ''
		ld	(hl),080h				; 10	; enable DAC
		dec	l					;  4	; control port
		znop						;  4	; ''
		ld	(hl),02Ah				; 10	; set to DAC port
		inc	l					;  4	; data port

Loop:
		ei						;  4	; enable interrupts
		jp	Loop					; 10	; idle

; ===========================================================================
; ---------------------------------------------------------------------------
; Buffers
; ---------------------------------------------------------------------------

		align	0100h
BufferA:	dsb	160,080h

		align	0100h
BufferB:	dsb	160,080h

; ===========================================================================